package database

import (
	"database/sql"
	"reflect"
)

func getNodeAddr(db *sql.DB) (nodeAddr string) {
	defer func() {
		if r := recover(); r != nil {
			nodeAddr = "unknown"
		}
	}()
	dbValue := reflect.Indirect(reflect.ValueOf(db))
	connector := dbValue.FieldByName("connector").Elem()
	connConfig := connector.FieldByName("ConnConfig")
	config := connConfig.FieldByName("Config")
	nodeAddr = config.FieldByName("Host").String()
	return
}
