package externalhttp

import (
	"fmt"
)

type InvalidRequestError struct {
	err error
}

func (e InvalidRequestError) Error() string {
	return fmt.Errorf("invalid request: %w", e.err).Error()
}

type RequestTravelAPIError struct {
	err error
}

func (e RequestTravelAPIError) Error() string {
	return fmt.Errorf("error while requesting travel api: %w", e.err).Error()
}

type TravelAPINotFoundError struct {
	content string
}

func NewTravelAPINotFoundError(content string) error {
	return &TravelAPINotFoundError{content: content}
}

func (e TravelAPINotFoundError) Error() string {
	return e.content
}
