package extractors

import (
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type StationsRepository interface {
	Get(int) (*rasp.TStation, bool)
}

type StationCodesRepository interface {
	GetStationIDByCode(string) (int32, bool)
	GetStationIDByExpressCode(string) (int32, bool)
}

type SettlementsRepository interface {
	GetByGeoID(int) (*rasp.TSettlement, bool)
	GetByCode(string) (*rasp.TSettlement, bool)
	Get(id int) (*rasp.TSettlement, bool)
}

type SettlementByStation interface {
	Map(stationID int32) (settlementID int32, found bool)
}

type StationToSettlementRepository interface {
	Get(id int) (*rasp.TStation2Settlement, bool)
}
