package extractors

import "fmt"

type ErrUnknownOrderType struct {
	message string
}

func newErrUnknownOrderType(orderID string, orderType string) *ErrUnknownOrderType {
	return &ErrUnknownOrderType{fmt.Sprintf("order with id = %s has unknown type: %v", orderID, orderType)}
}

func (e *ErrUnknownOrderType) Error() string {
	return e.message
}

type ErrNoOrderItems struct {
	message string
}

func newErrNoOrderItems(orderID string) *ErrNoOrderItems {
	return &ErrNoOrderItems{message: fmt.Sprintf("order with id = %s has no items", orderID)}
}

func (e *ErrNoOrderItems) Error() string {
	return e.message
}

type ErrNoDestination struct {
	message string
}

func newErrNoDestination(orderID string) *ErrNoDestination {
	return &ErrNoDestination{message: fmt.Sprintf("order with id = %s has no destination", orderID)}
}

func (e *ErrNoDestination) Error() string {
	return e.message
}

type ErrInvalidDestination struct {
	message string
}

func newErrInvalidDestination(orderID string, destination string) *ErrInvalidDestination {
	return &ErrInvalidDestination{message: fmt.Sprintf("order with id = %s has invalid destination: %s", orderID, destination)}
}

func (e *ErrInvalidDestination) Error() string {
	return e.message
}

type ErrSameOriginDestination struct {
	message string
}

func newErrSameOriginDestination(orderID string, destination string) *ErrSameOriginDestination {
	return &ErrSameOriginDestination{message: fmt.Sprintf("order with id = %s has same origin and destination: %s", orderID, destination)}
}

func (e *ErrSameOriginDestination) Error() string {
	return e.message
}

type ErrUnknownDestination struct {
	message string
}

func newErrUnknownDestination(orderID string, destination interface{}) *ErrUnknownDestination {
	return &ErrUnknownDestination{message: fmt.Sprintf("order with id = %s has unknown destination: %s", orderID, destination)}
}

func (e *ErrUnknownDestination) Error() string {
	return e.message
}

type ErrDestinationWithoutSettlement struct {
	message string
}

func newErrStationWithoutSettlement(orderID string, stationID int32) *ErrDestinationWithoutSettlement {
	return &ErrDestinationWithoutSettlement{message: fmt.Sprintf("order with id = %s has unknown destination: %d", orderID, stationID)}
}

func (e *ErrDestinationWithoutSettlement) Error() string {
	return e.message
}

type ErrUnknownGeoID struct {
	message string
}

func newErrUnknownGeoID(orderID string, geoID int) *ErrUnknownGeoID {
	return &ErrUnknownGeoID{message: fmt.Sprintf("order with id = %s has destination with unknown geoID: %d", orderID, geoID)}
}

func (e *ErrUnknownGeoID) Error() string {
	return e.message
}

type ErrHotelOrderWithoutSettlementGeoID struct {
	message string
}

func newErrHotelOrderWithoutSettlementGeoID(orderID string) *ErrHotelOrderWithoutSettlementGeoID {
	return &ErrHotelOrderWithoutSettlementGeoID{message: fmt.Sprintf("order with id = %s has settlement geoID", orderID)}
}

func (e *ErrHotelOrderWithoutSettlementGeoID) Error() string {
	return e.message
}
