package extractors

type StationIDToSettlementIDMapper struct {
	stationsRepository            StationsRepository
	stationToSettlementRepository StationToSettlementRepository
}

func NewStationIDToSettlementIDMapper(
	stationsRepository StationsRepository,
	stationToSettlementsRepository StationToSettlementRepository,
) *StationIDToSettlementIDMapper {
	return &StationIDToSettlementIDMapper{
		stationsRepository:            stationsRepository,
		stationToSettlementRepository: stationToSettlementsRepository,
	}
}

func (s StationIDToSettlementIDMapper) Map(stationID int32) (settlementID int32, found bool) {
	if stationToSettlement, ok := s.stationToSettlementRepository.Get(int(stationID)); ok && stationToSettlement.SettlementId > 0 {
		return stationToSettlement.SettlementId, true
	}
	if station, ok := s.stationsRepository.Get(int(stationID)); ok && station.SettlementId > 0 {
		return station.SettlementId, true
	}
	return 0, false
}
