package geo

import (
	"github.com/golang/geo/s1"
	"github.com/golang/geo/s2"
)

func GetDistanceKM(fromLat, fromLong, toLat, toLong float64) float64 {
	pointFrom := s2.PointFromLatLng(s2.LatLngFromDegrees(fromLat, fromLong))
	pointTo := s2.PointFromLatLng(s2.LatLngFromDegrees(toLat, toLong))
	km := angleToKM(pointFrom.Distance(pointTo))
	return km
}

func angleToKM(angle s1.Angle) float64 {
	// The Earth's mean radius in kilometers (according to NASA).
	const earthRadiusKm = 6371.01
	return earthRadiusKm * float64(angle)
}
