package logging

import (
	"google.golang.org/protobuf/proto"

	uapb "a.yandex-team.ru/logbroker/unified_agent/plugins/grpc_input/proto"
	"a.yandex-team.ru/travel/library/go/unifiedagent"
)

type UnifiedAgentLogger struct {
	unifiedAgentClient unifiedagent.Client
	logName            string
}

func NewUnifiedAgentLogger(logName string, unifiedAgentClient unifiedagent.Client) *UnifiedAgentLogger {
	return &UnifiedAgentLogger{logName: logName, unifiedAgentClient: unifiedAgentClient}
}

func (l *UnifiedAgentLogger) Log(message proto.Message) error {
	meta := []*uapb.Request_MessageMetaItem{{Key: "log_name", Value: []string{l.logName}}}
	return l.unifiedAgentClient.Send(message, meta)
}

func (l *UnifiedAgentLogger) LogJSON(message interface{}) error {
	meta := []*uapb.Request_MessageMetaItem{{Key: "log_name", Value: []string{l.logName}}}
	return l.unifiedAgentClient.SendJSON(message, meta)
}
