package template

import (
	"context"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/library/go/sender"
)

func NewSenderTemplateSender(config map[string]interface{}, senderClient sender.Client) (TemplateSender, error) {
	slugI, exists := config["campaign_slug"]
	if !exists {
		return nil, xerrors.Errorf("cannot create sender: campaign_slug is not specified")
	}
	slug, casted := slugI.(string)
	if !casted {
		return nil, xerrors.Errorf("cannot create sender: campaign_slug is not a string")
	}
	if slug == "" {
		return nil, xerrors.Errorf("cannot create sender: campaign_slug is empty")
	}
	return &senderAdapter{campaignSlug: slug, senderClient: senderClient}, nil
}

type senderAdapter struct {
	campaignSlug string
	senderClient sender.Client
}

func (s senderAdapter) Send(ctx context.Context, email string, arguments map[string]string) error {
	_, err := s.senderClient.SendTransactional(
		ctx,
		sender.TransactionalRequest{
			CampaignSlug: s.campaignSlug,
			ToEmail:      email,
			SendAsync:    false,
			Args:         arguments,
			Headers:      nil,
		},
	)
	return err
}
