package models

import "time"

type Variant struct {
	ID          uint `gorm:"primaryKey;type:bigserial;autoIncrement"`
	CreatedAt   time.Time
	ForwardKey  string `gorm:"uniqueIndex:variant_index,priority:1;type:varchar(400)"` // DP_404_9600213_9600370_202105012230;DP_340_9600370_9623547_202106012230
	BackwardKey string `gorm:"uniqueIndex:variant_index,priority:2;type:varchar(400)"`
}

type BetterPriceSubscription struct {
	CreatedAt time.Time
	UpdatedAt time.Time

	RecipientID int32     `gorm:"primaryKey"`
	Recipient   Recipient `gorm:"foreignKey:RecipientID"`
	VariantID   uint      `gorm:"primaryKey"`
	Variant     Variant   `gorm:"foreignKey:VariantID"`

	ServiceClass string `gorm:"primaryKey;type:varchar(10)"`
	WithBaggage  bool   `gorm:"primaryKey"`
	Adults       uint32 `gorm:"primaryKey;type:smallint"`
	Children     uint32 `gorm:"primaryKey;type:smallint"`
	Infants      uint32 `gorm:"primaryKey;type:smallint"`

	FromPointKey    string `gorm:"type:varchar(10)"`
	ToPointKey      string `gorm:"type:varchar(10)"`
	DateForward     string `gorm:"type:varchar(10)"`
	DateBackward    string `gorm:"type:varchar(10)"`
	NationalVersion string `gorm:"type:varchar(10)"`
	Language        string `gorm:"type:varchar(2)"`

	PriceWithoutBaggageValue             float64
	PriceWithoutBaggageCurrency          string `gorm:"type:varchar(10)"`
	ExchangedPriceWithoutBaggageValue    float64
	ExchangedPriceWithoutBaggageCurrency string `gorm:"type:varchar(10)"`

	PriceWithBaggageValue             float64
	PriceWithBaggageCurrency          string `gorm:"type:varchar(10)"`
	ExchangedPriceWithBaggageValue    float64
	ExchangedPriceWithBaggageCurrency string `gorm:"type:varchar(10)"`
}
