package models

import (
	"fmt"
	"time"
)

type OrderValueDBError struct {
	valueType       string
	unexpectedValue string
}

func (e OrderValueDBError) Error() string {
	return fmt.Sprintf("unknown value of %v: %v", e.valueType, e.unexpectedValue)
}

type Order struct {
	ID           string `gorm:"primaryKey;type:varchar(100)"`
	Type         OrderType
	State        OrderState
	StartDate    time.Time
	ArrivalDate  time.Time // used for weather and events blocks
	CreatedAt    time.Time
	WasFulfilled bool

	CorrelationID           string `gorm:"index"`
	DestinationSettlementID int    // only filled while building a notification, to facilitate testing/debugging
}

func NewOrder() Order {
	return Order{}
}

func (r Order) IsNotifyable() bool {
	return r.State == OrderFulfilled
}
