package models

import (
	"database/sql/driver"
	"fmt"
)

type OrderState string

const (
	OrderIncomplete OrderState = "incomplete"
	OrderCancelled  OrderState = "cancelled" // Cancelled or Refunded
	OrderFulfilled  OrderState = "fulfilled"
)

var allOrderStates = toOrderStateMap([]OrderState{OrderIncomplete, OrderCancelled, OrderFulfilled})

func (s *OrderState) Scan(value interface{}) error {
	strValue := fmt.Sprintf("%v", value)
	if strValue == "" {
		*s = OrderIncomplete
		return nil
	}
	result, ok := allOrderStates[strValue]
	if !ok {
		return OrderValueDBError{"OrderState", strValue}
	}
	*s = result
	return nil
}

func (s OrderState) Value() (driver.Value, error) {
	return string(s), nil
}

func toOrderStateMap(orderStates []OrderState) map[string]OrderState {
	result := make(map[string]OrderState)
	for _, orderState := range orderStates {
		result[string(orderState)] = orderState
	}
	return result
}
