package models

import (
	"time"
)

type User struct {
	ID         uint64  `gorm:"primaryKey;autoIncrement"`
	PassportID *string `gorm:"unique"`
	CreatedAt  time.Time
	UpdatedAt  time.Time
}

func NewUser() User {
	return User{}
}

func (u User) WithPassportID(passportID string) User {
	u.PassportID = &passportID
	return u
}

func (u User) GetPassportID() string {
	if u.PassportID == nil {
		return ""
	}
	return *u.PassportID
}
