package orderchanges

import "context"

type OrderChangedSource string

const (
	OrderChangedSourceSync  OrderChangedSource = "sync"
	OrderChangedSourceQueue OrderChangedSource = "queue"
)

type OrderChangedRequest struct {
	OrderID string
	Source  OrderChangedSource
}

type OrderChangedStatus int

const (
	OrderChangedStatusOK OrderChangedStatus = iota
	OrderChangedStatusTemporaryError
	OrderChangedStatusFailure
)

type OrderChangedResult struct {
	Status  OrderChangedStatus
	Message string
	Code    string
}

type OnOrderChanged func(context.Context, OrderChangedRequest) OrderChangedResult
