package orders

import (
	"a.yandex-team.ru/travel/notifier/internal/models"
)

type ErrUnknownOrderType interface {
	error
}

type errUnknownOrderTypeImpl struct {
	message string
}

func (e *errUnknownOrderTypeImpl) Error() string {
	return e.message
}

type ErrInvalidOrder interface {
	error
	OrderType() models.OrderType
}

type errInvalidOrderImpl struct {
	message   string
	orderType models.OrderType
}

func (e *errInvalidOrderImpl) Error() string {
	return e.message
}

func (e *errInvalidOrderImpl) OrderType() models.OrderType {
	return e.orderType
}
