package pgclient

import (
	"context"
	"database/sql"
	"log"
	"os"
	"time"

	"golang.yandex/hasql"
	"golang.yandex/hasql/checkers"
	"gorm.io/driver/postgres"
	"gorm.io/gorm"
	"gorm.io/gorm/logger"
)

func gormWrapper(node hasql.Node, logLevel logger.LogLevel) (*gorm.DB, error) {
	return gorm.Open(
		postgres.New(
			postgres.Config{
				Conn: node.DB(),
			},
		), &gorm.Config{
			Logger: logger.New(
				log.New(os.Stdout, "\r\n", log.LstdFlags),
				logger.Config{SlowThreshold: 2 * time.Second, LogLevel: logLevel},
			),
		},
	)
}

func (c *PGClient) nodeChecker(ctx context.Context, db *sql.DB) (bool, error) {
	start := time.Now()
	isPrimary, err := checkers.Check(ctx, db, "SELECT NOT pg_is_in_recovery()")
	latency := time.Since(start)
	go c.onCheckedNode(db, latency)
	return isPrimary, err
}
