package protoutils

import (
	"time"

	"github.com/golang/protobuf/ptypes"
	"github.com/golang/protobuf/ptypes/timestamp"

	"a.yandex-team.ru/library/go/ptr"
	proto "a.yandex-team.ru/travel/proto"
)

func MapDate(dateProto *proto.TDate) *time.Time {
	if dateProto == nil {
		return nil
	}
	return ptr.Time(time.Date(int(dateProto.Year), time.Month(dateProto.Month), int(dateProto.Day), 0, 0, 0, 0, time.UTC))
}

func MapTimestamp(datetimeProto *timestamp.Timestamp) (*time.Time, error) {
	if datetimeProto == nil {
		return nil, nil
	}
	datetime, err := ptypes.Timestamp(datetimeProto)
	return &datetime, err
}
