package grpc

import (
	"context"

	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"

	grpcserver "a.yandex-team.ru/travel/library/go/grpcutil/server"
	pullnotifications "a.yandex-team.ru/travel/notifier/api/pull_notifications/v1"
	service "a.yandex-team.ru/travel/notifier/internal/service/pullnotifications"
)

type Service struct {
	service *service.Service
}

func NewService(service *service.Service) *Service {
	return &Service{service: service}
}

func (s *Service) GetAll(ctx context.Context, req *pullnotifications.GetPullNotificationsReqV1) (*pullnotifications.GetPullNotificationsRspV1, error) {
	if req.GetPassportId() == "" {
		return nil, status.Error(codes.InvalidArgument, "passport_is required")
	}
	notifications, err := s.service.GetAll(ctx, req.GetPassportId())
	if err != nil {
		return nil, status.Error(codes.Unknown, err.Error())
	}
	return &pullnotifications.GetPullNotificationsRspV1{Notifications: notifications}, nil
}

func (s *Service) GetByOrderIDs(ctx context.Context, req *pullnotifications.GetPullNotificationsByOrdersIdsReqV1) (*pullnotifications.GetPullNotificationsByOrdersIdsRspV1, error) {
	notifications, err := s.service.GetByOrderIDs(ctx, req.GetOrderIds())
	if err != nil {
		return nil, status.Error(codes.Unknown, err.Error())
	}
	return &pullnotifications.GetPullNotificationsByOrdersIdsRspV1{Notifications: notifications}, nil
}

func (s *Service) GetServiceRegisterer() grpcserver.ServiceRegisterer {
	return func(server *grpc.Server) {
		pullnotifications.RegisterPullNotificationsAPIServer(server, s)
	}
}
