package rollout

type EmailFilter struct {
	config EmailRules
}

func NewEmailFilter(config EmailRules) *EmailFilter {
	return &EmailFilter{config: config}
}

func (f *EmailFilter) Allows(email string) bool {
	for _, rule := range f.config.AlwaysAllowed {
		if rule.Apply(email) {
			return true
		}
	}
	for _, rule := range f.config.Banned {
		if rule.Apply(email) {
			return false
		}
	}
	for _, rule := range f.config.Allowed {
		if rule.Apply(email) {
			return true
		}
	}
	return false
}
