package onlineregistration

import (
	"context"
	"time"

	"a.yandex-team.ru/travel/notifier/internal/models"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type NotificationsScheduler interface {
	Schedule(context.Context, models.Notification, time.Time) (*models.Notification, error)
	CancelPlannedNotificationsByOrderID(context.Context, string, models.NotificationType, models.DispatchType) ([]models.Notification, error)
	ScheduleMany(context.Context, []models.Notification, time.Time) ([]models.Notification, error)
	AlreadySentForOrder(context.Context, string) ([]models.Notification, error)
}

type UsersRepository interface {
	GetOrCreate(context.Context, models.User) (*models.User, error)
}

type TimeZoneDataProvider interface {
	Get(timeZoneID int) (*time.Location, bool)
}

type StationCodesRepository interface {
	GetStationIDByCode(string) (int32, bool)
}

type StationsRepository interface {
	Get(int) (*rasp.TStation, bool)
}

type CarriersRepository interface {
	Get(int) (*rasp.TCarrier, bool)
}
