package onlineregistration

import (
	"time"

	"github.com/stretchr/testify/mock"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

type mockStationCodesRepository struct {
	mock.Mock
}

func (m *mockStationCodesRepository) GetStationIDByCode(code string) (int32, bool) {
	args := m.Called(code)
	return args.Get(0).(int32), args.Bool(1)
}

type mockStationsRepository struct {
	mock.Mock
}

func (m *mockStationsRepository) Get(i int) (*rasp.TStation, bool) {
	args := m.Called(i)
	return args.Get(0).(*rasp.TStation), args.Bool(1)
}

type mockTimezoneDataProvider struct {
	mock.Mock
}

func (m *mockTimezoneDataProvider) Get(timeZoneID int) (*time.Location, bool) {
	args := m.Called(timeZoneID)
	return args.Get(0).(*time.Location), args.Bool(1)
}
