package orderchanges

import (
	"context"

	"a.yandex-team.ru/travel/notifier/internal/models"
	"a.yandex-team.ru/travel/notifier/internal/orderchanges"
	"a.yandex-team.ru/travel/notifier/internal/orders"
)

type OrderProvider interface {
	GetOrderInfoByID(context.Context, string) (*orders.OrderInfo, error)
}

type OrderStatusChecker interface {
	Check(ctx context.Context, order models.Order) (bool, error)
}

type OnOrderChangedSubscriber interface {
	OnOrderChanged(context.Context, *orders.OrderInfo) orderchanges.OrderChangedResult
}

type OrdersRepository interface {
	GetByCorrelationID(ctx context.Context, correlationID string) ([]models.Order, error)
	GetByID(ctx context.Context, orderID string) (models.Order, error)
	Upsert(ctx context.Context, order models.Order) error
}
