package polling

import (
	"time"

	"a.yandex-team.ru/travel/notifier/internal/constants"
	"a.yandex-team.ru/travel/notifier/internal/rollout"
)

type Config struct {
	Interval              time.Duration      `config:"POLLING_INTERVAL" yaml:"interval"`
	MaxIterationDuration  time.Duration      `config:"POLLING_MAX_ITERATION_DURATION" yaml:"max_iteration_duration"`
	PostponedPerBatch     uint               `yaml:"postponed_per_batch"`
	NotSentPerBatch       uint               `yaml:"not_sent_per_batch"`
	PlannedPerBatch       uint               `yaml:"planned_per_batch"`
	YtLockCluster         string             `config:"YT_LOCK_CLUSTER" yaml:"yt_lock_cluster"`
	YtLockToken           string             `config:"YT_LOCK_TOKEN" yaml:"yt_lock_token"`
	PollingLockPathPrefix string             `config:"YT_LOCK_PATH_PREFIX" yaml:"yt_lock_path_prefix"`
	PollingLockDirectory  string             `config:"YT_LOCK_DIRECTORY" yaml:"yt_lock_directory"`
	Disabled              bool               `config:"POLLING_DISABLED" yaml:"disabled"`
	EmailRules            rollout.EmailRules `yaml:"email_rules"`
}

var DefaultConfig = Config{
	Interval:              60 * time.Second,
	MaxIterationDuration:  120 * time.Second,
	PostponedPerBatch:     5,
	NotSentPerBatch:       5,
	PlannedPerBatch:       10,
	YtLockCluster:         "locke",
	PollingLockPathPrefix: constants.DefaultYtLockPathPrefix,
	PollingLockDirectory:  "polling",
	Disabled:              false,
}

const (
	metricsPrefix  = "polling"
	lockMetricName = "yt_locks"
)
