package polling

import (
	"github.com/gofrs/uuid"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/notifier/internal/models"
	"a.yandex-team.ru/travel/notifier/internal/rollout"
)

type EmailFilter struct {
	filter *rollout.EmailFilter
	logger log.Logger
}

func NewEmailFilter(logger log.Logger, filter *rollout.EmailFilter) *EmailFilter {
	return &EmailFilter{logger: logger.WithName("EmailFilter"), filter: filter}
}

func (f *EmailFilter) Filter(iterationID uuid.UUID, notifications []models.Notification) []models.Notification {
	allowed := make([]models.Notification, 0)
	for _, notification := range notifications {
		if f.filter.Allows(notification.Recipient.GetEmail()) {
			allowed = append(allowed, notification)
		} else {
			f.logger.Info(
				"notification has been filtered out",
				log.String("iterationID", iterationID.String()),
				log.UInt64("notificationID", notification.ID),
			)
		}
	}
	return allowed
}
