package audioguide

import (
	"context"
	"encoding/json"
	"errors"
	"strconv"

	"a.yandex-team.ru/travel/notifier/internal/externalhttp"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks"
	"a.yandex-team.ru/travel/notifier/internal/structs"
)

const (
	maxNumberOfAudioGuidesToFetch = 3 * maxNumberOfAudioGuidesToSend
)

type IziTravelClient struct {
	httpClient *externalhttp.HTTPClient
}

func NewAudioGuidesProvider(httpClient *externalhttp.HTTPClient) *IziTravelClient {
	return &IziTravelClient{
		httpClient: httpClient,
	}
}

func (c *IziTravelClient) GetAudioGuides(ctx context.Context, geoID int) (structs.AudioGuidesForCity, error) {
	result := structs.NewAudioGuidesForCity()
	params := map[string]string{
		"resultsLimit": strconv.Itoa(maxNumberOfAudioGuidesToFetch),
		"geoId":        strconv.Itoa(geoID),
	}
	jsonBytes, err := c.httpClient.GetJSON(ctx, params)
	if err != nil {
		if errors.As(err, &externalhttp.TravelAPINotFoundError{}) {
			return result, blocks.ErrDataNotFound
		}
		return result, err
	}

	if err = json.Unmarshal(jsonBytes, &result); err != nil {
		return result, err
	}
	return result, nil
}
