package beforedeparture

import (
	"context"
	"fmt"

	"a.yandex-team.ru/travel/library/go/renderer"
	"a.yandex-team.ru/travel/library/go/tanker"
	"a.yandex-team.ru/travel/notifier/internal/models"
	"a.yandex-team.ru/travel/notifier/internal/orders"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

const (
	urlPattern = "https://yastat.net/s3/travel-mail/icons/before-departure/%s.png"
)

type Provider struct {
	texts tanker.Keyset
}

func NewProvider(texts tanker.Keyset) *Provider {
	return &Provider{
		texts: texts,
	}
}

func (p *Provider) GetBlock(ctx context.Context, orderInfo *orders.OrderInfo, notification models.Notification) (renderer.Block, error) {
	block := ui.NewBeforeDepartureBlock()
	block.Title = p.texts.GetSingular("block.title", "ru")
	block.PartingWishes = p.texts.GetSingular("block.wishes", "ru")
	block.SubBlocks = []ui.BeforeDepartureSubBlock{
		{
			Title: p.texts.GetSingular("take-with-you.title", "ru"),
			Items: []ui.BeforeDepartureBlockItem{
				{
					Icon:        fmt.Sprintf(urlPattern, "Passport"),
					Description: p.texts.GetSingular("take-with-you.passport.text", "ru"),
				},
				{
					Icon:        fmt.Sprintf(urlPattern, "Ticket"),
					Description: p.texts.GetSingular("take-with-you.ticket.text", "ru"),
				},
				{
					Icon:        fmt.Sprintf(urlPattern, "CreditCard"),
					Description: p.texts.GetSingular("take-with-you.creditcard.text", "ru"),
				},
				{
					Icon:        fmt.Sprintf(urlPattern, "Phone"),
					Description: p.texts.GetSingular("take-with-you.phone.text", "ru"),
				},
			},
		},
		{
			Title: p.texts.GetSingular("dont-forget.title", "ru"),
			Items: []ui.BeforeDepartureBlockItem{
				{
					Icon:        fmt.Sprintf(urlPattern, "Fire"),
					Description: p.texts.GetSingular("dont-forget.fire.text", "ru"),
				},
				{
					Icon:        fmt.Sprintf(urlPattern, "Window"),
					Description: p.texts.GetSingular("dont-forget.window.text", "ru"),
				},
				{
					Icon:        fmt.Sprintf(urlPattern, "Electric"),
					Description: p.texts.GetSingular("dont-forget.electric.text", "ru"),
				},
				{
					Icon:        fmt.Sprintf(urlPattern, "Flowers"),
					Description: p.texts.GetSingular("dont-forget.flowers.text", "ru"),
				},
				{
					Icon:        fmt.Sprintf(urlPattern, "Refrige"),
					Description: p.texts.GetSingular("dont-forget.refrige.text", "ru"),
				},
				{
					Icon:        fmt.Sprintf(urlPattern, "Trash"),
					Description: p.texts.GetSingular("dont-forget.trash.text", "ru"),
				},
			},
		},
	}

	return block, nil
}

func (p *Provider) GetBlockType() blocks.BlockType {
	return blocks.BeforeDepartureBlock
}
