package disclaimers

import (
	"a.yandex-team.ru/travel/library/go/renderer"
	"a.yandex-team.ru/travel/library/go/tanker"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

type Provider struct {
	texts tanker.Keyset
}

func NewProvider(texts tanker.Keyset) *Provider {
	return &Provider{texts: texts}
}

func (p *Provider) GetDisclaimersBlock(collectedBlockTypes blocks.BlockTypesSet) (renderer.Block, error) {
	textKeyMap := map[blocks.BlockType][]string{
		blocks.RidesBlock:      []string{"go.disclaimer"},
		blocks.MoviesBlock:     []string{"music.disclaimer", "kinopoisk.disclaimer"},
		blocks.AudioGuideBlock: []string{"audioguides.disclaimer"},
	}
	result := make([]string, 0, 4)
	for k, v := range textKeyMap {
		if ok := collectedBlockTypes[k]; ok {
			for _, textKey := range v {
				result = append(result, p.texts.GetSingular(textKey, "ru"))
			}
		}
	}
	return ui.NewDisclaimers(result), nil
}

func (p *Provider) GetBlockType() blocks.BlockType {
	return blocks.DisclaimersBlock
}
