package footer

import (
	"context"

	"a.yandex-team.ru/travel/library/go/renderer"
	"a.yandex-team.ru/travel/library/go/tanker"
	"a.yandex-team.ru/travel/notifier/internal/models"
	"a.yandex-team.ru/travel/notifier/internal/orders"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/interfaces"
)

type Provider struct {
	texts                    tanker.Keyset
	unsubscribeLinkGenerator interfaces.UnsubscribeLinkGenerator
}

func NewProvider(
	texts tanker.Keyset,
	unsubscribeLinkGenerator interfaces.UnsubscribeLinkGenerator,
) *Provider {
	return &Provider{texts: texts, unsubscribeLinkGenerator: unsubscribeLinkGenerator}
}

func (p *Provider) GetBlock(ctx context.Context, orderInfo *orders.OrderInfo, notification models.Notification) (renderer.Block, error) {
	unsubscribeLink := p.unsubscribeLinkGenerator.Generate(*notification.Recipient)
	return ui.NewFooterBlock(
		[]ui.ImageLink{},
		ui.Support{},
		[]ui.Link{{Text: p.texts.GetSingular("unsubscribe", "ru"), URL: unsubscribeLink}},
	), nil
}

func (p *Provider) GetBlockType() blocks.BlockType {
	return blocks.FooterBlock
}
