package header

import (
	"context"

	"a.yandex-team.ru/travel/library/go/renderer"
	"a.yandex-team.ru/travel/notifier/internal/models"
	"a.yandex-team.ru/travel/notifier/internal/orders"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

type Provider struct {
}

func NewProvider() *Provider {
	return &Provider{}
}

func (p *Provider) GetBlock(ctx context.Context, orderInfo *orders.OrderInfo, notification models.Notification) (renderer.Block, error) {
	return ui.NewHeader(
		"https://yastat.net/s3/travel-mail/icons/TravelLogo.png",
		[]ui.Link{},
	), nil
}

func (p *Provider) GetBlockType() blocks.BlockType {
	return blocks.HeaderBlock
}
