package hotels

import (
	"context"
	"encoding/json"
	"errors"
	"strconv"

	"a.yandex-team.ru/travel/notifier/internal/externalhttp"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks"
	"a.yandex-team.ru/travel/notifier/internal/structs"
)

type HotelsClient struct {
	httpClient *externalhttp.HTTPClient
}

func NewHotelsClient(httpClient *externalhttp.HTTPClient) *HotelsClient {
	return &HotelsClient{
		httpClient: httpClient,
	}
}

func (c *HotelsClient) GetHotels(ctx context.Context, geoID int, orderID string, limit int) (*structs.HotelPayload, error) {
	params := map[string]string{
		"limit":   strconv.Itoa(limit),
		"orderId": orderID,
		"geoId":   strconv.Itoa(geoID),
	}
	jsonBytes, err := c.httpClient.GetJSON(ctx, params)
	if err != nil {
		if errors.As(err, &externalhttp.TravelAPINotFoundError{}) {
			return nil, blocks.ErrDataNotFound
		}
		return nil, err
	}

	result := &structs.HotelPayload{}
	if err = json.Unmarshal(jsonBytes, result); err != nil {
		return result, err
	}
	return result, nil
}
