package blocks

import (
	"strconv"

	"a.yandex-team.ru/travel/library/go/metrics"
)

const (
	pretripBlocksMetricsPrefix = "pretrip.blocks"
)

func writeMetric(success bool, blockType BlockType, isRequired bool) {
	status := "success"
	if !success {
		status = "failed"
	}
	metrics.GlobalAppMetrics().GetOrCreateCounter(
		pretripBlocksMetricsPrefix,
		map[string]string{
			"status":      status,
			"block_type":  blockTypeToString[blockType],
			"is_required": strconv.FormatBool(isRequired),
		},
		"collecting",
	).Inc()
}
