package movies

import (
	"context"

	"a.yandex-team.ru/travel/library/go/renderer"
	"a.yandex-team.ru/travel/library/go/tanker"
	"a.yandex-team.ru/travel/notifier/internal/models"
	"a.yandex-team.ru/travel/notifier/internal/orders"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks/ui"
)

type Provider struct {
	texts tanker.Keyset
}

func NewProvider(texts tanker.Keyset) *Provider {
	return &Provider{
		texts: texts,
	}
}

func (p *Provider) GetBlock(ctx context.Context, orderInfo *orders.OrderInfo, notification models.Notification) (renderer.Block, error) {
	return ui.NewUsefulBlock(
		p.texts.GetSingular("block.title", "ru"),
		p.texts.GetSingular("block.subtitle", "ru"),
		[]ui.UsefulBlockItem{
			{
				Image:       "https://yastat.net/s3/travel-mail/icons/products/Music.png",
				Title:       p.texts.GetSingular("music.title", "ru"),
				Description: p.texts.GetSingular("music.description", "ru"),
				URL:         p.texts.GetSingular("music.url", "ru"),
			},
			{
				Image:       "https://yastat.net/s3/travel-mail/icons/products/Kinopoisk.png",
				Title:       p.texts.GetSingular("kinopoisk.title", "ru"),
				Description: p.texts.GetSingular("kinopoisk.description", "ru"),
				URL:         p.texts.GetSingular("kinopoisk.url", "ru"),
			},
		},
	), nil
}

func (p *Provider) GetBlockType() blocks.BlockType {
	return blocks.MoviesBlock
}
