package ui

type CarouselBlockItemInterface interface {
	getImage() string
	getTitle() string
	getURL() string
}

type CarouselBlockItemBase struct {
	Image string `json:"image"`
	Title string `json:"title"`
	URL   string `json:"url,omitempty"`
}

func (c CarouselBlockItemBase) getImage() string {
	return c.Image
}

func (c CarouselBlockItemBase) getTitle() string {
	return c.Title
}

func (c CarouselBlockItemBase) getURL() string {
	return c.URL
}

type CommonCarouselBlockItem struct {
	CarouselBlockItemBase
	Description string              `json:"description"`
	Info        CarouselIconAndText `json:"info"`
}

type HotelCarouselBlockItem struct {
	CarouselBlockItemBase
	Rating        float32  `json:"rating"`
	Stars         int      `json:"stars"`
	Reviews       string   `json:"reviews"`
	OrderInfo     []string `json:"orderInfo"`
	Price         string   `json:"price"`
	Accommodation string   `json:"accommodation"`
}

type CarouselIconAndText struct {
	Icon string `json:"icon"`
	Text string `json:"text"`
}

type CarouselBlock struct {
	Type     string                       `json:"type"`
	Title    string                       `json:"title"`
	Subtitle string                       `json:"subtitle"`
	Items    []CarouselBlockItemInterface `json:"items"`
	Action   SecondaryAction              `json:"action,omitempty"`
}

func NewCarouselBlock() CarouselBlock {
	return CarouselBlock{Type: BlockTypeCarousel.String(), Items: make([]CarouselBlockItemInterface, 0)}
}
