package ui

type FooterBlock struct {
	Type    string      `json:"type"`
	Social  []ImageLink `json:"social"`
	Support Support     `json:"support"`
	Links   []Link      `json:"links"`
}

type Support struct {
	PhoneNumber string `json:"phoneNumber"`
	Hint        string `json:"hint"`
}

func NewFooterBlock(social []ImageLink, support Support, links []Link) FooterBlock {
	return FooterBlock{Type: BlockTypeFooter.String(), Social: social, Support: support, Links: links}
}
