package ui

type (
	HotelOrder struct {
		Type        string           `json:"type"`
		Title       string           `json:"title"`
		HotelName   string           `json:"hotelName"`
		GeoPosition Link             `json:"geoPosition"`
		Dates       string           `json:"dates"`
		Checkin     string           `json:"checkin"`
		Checkout    string           `json:"checkout"`
		Download    *SecondaryAction `json:"download"`
		Image       string           `json:"image"`
	}
)

func NewHotelOrder(
	title string,
	hotelName string,
	geoPosition Link,
	dates string,
	checkin string,
	checkout string,
	download *SecondaryAction,
	imageURL string,
) HotelOrder {
	return HotelOrder{
		Type:        BlockTypeBooking.String(),
		Image:       imageURL,
		Title:       title,
		HotelName:   hotelName,
		GeoPosition: geoPosition,
		Dates:       dates,
		Checkin:     checkin,
		Checkout:    checkout,
		Download:    download,
	}
}
