package ui

type (
	TrainOrderBlock struct {
		Type         string           `json:"type"`
		Title        string           `json:"title"`
		OrderNumber  string           `json:"orderNumber"`
		Points       []string         `json:"points"`
		BoardingHint string           `json:"boardingHint"`
		Download     *SecondaryAction `json:"download"`
		Duration     string           `json:"duration"`
		TrainName    string           `json:"trainName"`
		TrainInfo    string           `json:"trainInfo"`
		Departure    TrainStationInfo `json:"departure"`
		Arrival      TrainStationInfo `json:"arrival"`
		Route        RouteInfo        `json:"route"`
		Facilities   []string         `json:"facilities"`
	}

	TrainStationInfo struct {
		Station      string `json:"station"`
		Time         string `json:"time"`
		Date         string `json:"date"`
		NextDateHint string `json:"nextDateHint"`
	}

	RouteInfo struct {
		Text string `json:"text"`
		URL  string `json:"url"`
	}
)

func NewTrainOrderBlock() TrainOrderBlock {
	return TrainOrderBlock{
		Type:       BlockTypeTrainTicket.String(),
		Facilities: []string{},
	}
}
