package ui

type BlockType string

func (u BlockType) String() string {
	return string(u)
}

const (
	BlockTypeBeforeDeparture BlockType = "BEFORE_DEPARTURE"
	BlockTypeCarousel        BlockType = "CAROUSEL"
	BlockTypeFooter          BlockType = "FOOTER"
	BlockTypeGreeting        BlockType = "GREETING"
	BlockTypeHeader          BlockType = "HEADER"
	BlockTypeUseful          BlockType = "USEFUL"
	BlockTypeWeather         BlockType = "WEATHER"
	BlockTypeDisclaimers     BlockType = "DISCLAIMERS"
	BlockTypeBooking         BlockType = "BOOKING"
	BlockTypeTrainTicket     BlockType = "TRAIN_TICKET"

	SecondaryActionTheme = "SECONDARY"
)

type ImageLink struct {
	Image string `json:"image"`
	URL   string `json:"url"`
}

type Link struct {
	Text string `json:"text"`
	URL  string `json:"url"`
}

type SecondaryAction struct {
	Text  string `json:"text"`
	Theme string `json:"theme"`
	URL   string `json:"url,omitempty"`
}
