package ui

type UsefulBlockItem struct {
	Image       string `json:"image"`
	Title       string `json:"title"`
	Description string `json:"description"`
	URL         string `json:"url"`
}

type UsefulBlock struct {
	Type     string            `json:"type"`
	Title    string            `json:"title"`
	Subtitle string            `json:"subtitle"`
	Items    []UsefulBlockItem `json:"items"`
}

func NewUsefulBlock(title string, subtitle string, items []UsefulBlockItem) UsefulBlock {
	return UsefulBlock{Type: BlockTypeUseful.String(), Title: title, Subtitle: subtitle, Items: items}
}
