package ui

type WeatherBlockItem struct {
	Day         string             `json:"day"`
	IsWeekend   bool               `json:"isWeekend"`
	Date        string             `json:"date"`
	Temperature WeatherTemperature `json:"temperature"`
	Conditions  WeatherConditions  `json:"conditions"`
}

type WeatherTemperature struct {
	Day   string `json:"day"`
	Night string `json:"night"`
}

type WeatherConditions struct {
	Icon        string `json:"icon"`
	Description string `json:"description"`
}

type WeatherBlock struct {
	Type   string             `json:"type"`
	Title  string             `json:"title"`
	Items  []WeatherBlockItem `json:"items"`
	Action SecondaryAction    `json:"action,omitempty"`
}

func NewWeatherBlock() WeatherBlock {
	return WeatherBlock{Type: BlockTypeWeather.String(), Items: make([]WeatherBlockItem, 0)}
}
