package weather

import (
	"context"
	"encoding/json"
	"errors"
	"strconv"

	"a.yandex-team.ru/travel/notifier/internal/externalhttp"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/blocks"
	"a.yandex-team.ru/travel/notifier/internal/structs"
)

const (
	numberOfDaysToRetrieve = 10
)

type WeatherClient struct {
	httpClient *externalhttp.HTTPClient
}

func NewWeatherProvider(httpClient *externalhttp.HTTPClient) *WeatherClient {
	return &WeatherClient{
		httpClient: httpClient,
	}
}

func (c *WeatherClient) GetWeather(ctx context.Context, geoID int, lang string) (structs.WeatherForCity, error) {
	result := structs.NewWeatherForCity()
	params := map[string]string{
		"geoid": strconv.Itoa(geoID),
		"lang":  lang,
		"limit": strconv.Itoa(numberOfDaysToRetrieve),
	}
	jsonBytes, err := c.httpClient.GetJSON(ctx, params)
	if err != nil {
		if errors.As(err, &externalhttp.TravelAPINotFoundError{}) {
			return result, blocks.ErrDataNotFound
		}
		return result, err
	}

	if err = json.Unmarshal(jsonBytes, &result); err != nil {
		return result, err
	}
	return result, nil
}
