package renderlog

import (
	"a.yandex-team.ru/travel/library/go/unifiedagent"
	"a.yandex-team.ru/travel/notifier/internal/logging"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/logging/renderlog/record"
)

const logName = "pretrip-render-log"

type Logger struct {
	unifiedAgentLogger *logging.UnifiedAgentLogger
}

func NewLogger(unifiedAgentClient unifiedagent.Client) *Logger {
	return &Logger{unifiedAgentLogger: logging.NewUnifiedAgentLogger(logName, unifiedAgentClient)}
}

func (l *Logger) Log(message *record.RenderLogRecord) error {
	return l.unifiedAgentLogger.Log(message)
}
