package pretrip

import (
	"time"

	"a.yandex-team.ru/library/go/core/metrics"
)

const (
	pretripMetricsPrefix = "pretrip"
	senderMetricsPrefix  = pretripMetricsPrefix + ".sender"

	processingPhaseMetricName = "processing"
	sendingPhaseMetricName    = "sending"

	successfulSendingMetricName      = "sent"
	failedSendingMetricName          = "failed"
	postponedNotificationMetricName  = "postponed"
	plannedNotificationMetricName    = "planned"
	notPlannedNotificationMetricName = "not_planned"

	// https://st.yandex-team.ru/RASPTICKETS-20094#602f8ad83ecb4c692d7258ec
	plannedAfterDeadlineNotificationMetricName = "planned_after_deadline"
	notPlannedAfterDeadlineMetricName          = "not_planned_after_deadline"

	expiredNotificationMetricName = "expired"
	senderTimingsMetricName       = "timings"
	senderRequestsMetricName      = "requests"

	postponementReasonNoOrder                  = "no_order"
	postponementReasonFailedDeduplication      = "failed_deduplication"
	postponementReasonFailedAlreadySentCheck   = "failed_already_sent_check"
	postponementReasonFailedTxCommit           = "failed_tx_commit"
	postponementReasonFailedNotificationUpdate = "failed_notification_update"
	postponementReasonFailedOrderFetching      = "failed_order_fetching"
	postponementReasonFailedOrderMapping       = "failed_order_mapping"
	postponementReasonFailedBlocksCollecting   = "failed_blocks_collecting"
	postponementReasonFailedRendering          = "failed_rendering"
)

var senderLatencyBuckets = metrics.MakeExponentialDurationBuckets(time.Millisecond, 1.3, 40)
