package pretrip

import (
	"context"
	"time"

	"a.yandex-team.ru/travel/notifier/internal/models"
	"a.yandex-team.ru/travel/notifier/internal/service/pretrip/interfaces"
)

type OrderStatusChecker struct {
	ordersRepository interfaces.OrdersRepository
	checkTimeout     time.Duration
}

func NewOrderStatusChecker(ordersRepository interfaces.OrdersRepository) *OrderStatusChecker {
	return &OrderStatusChecker{ordersRepository: ordersRepository, checkTimeout: 2 * time.Second}
}

func (c *OrderStatusChecker) Check(ctx context.Context, order models.Order) (bool, error) {
	localCtx, cancelFunc := context.WithTimeout(ctx, c.checkTimeout)
	defer cancelFunc()
	orderFromDB, err := c.ordersRepository.GetByID(localCtx, order.ID)
	if err != nil {
		return false, err
	}
	return orderFromDB.WasFulfilled || order.WasFulfilled, nil
}
