package processing

import "time"

type Config struct {
	SendToUnsubscribed         bool          `config:"PROCESSING_SEND_TO_UNSUBSCRIBED" yaml:"send_to_unsubscribed"`
	DBStatementTimeout         time.Duration `config:"PROCESSING_DB_STATEMENT_TIMEOUT" yaml:"db_statement_timeout"`
	DBLockTimeout              time.Duration `config:"PROCESSING_DB_LOCK_TIMEOUT" yaml:"db_lock_timeout"`
	DBIdleInTransactionTimeout time.Duration `config:"PROCESSING_DB_IDLE_IN_TRANSACTION_TIMEOUT" yaml:"db_idle_in_transaction_timeout"`
}

var DefaultConfig = Config{
	SendToUnsubscribed:         false,
	DBStatementTimeout:         60 * time.Second,
	DBLockTimeout:              10 * time.Second,
	DBIdleInTransactionTimeout: 60 * time.Second,
}

func WithConfig(config Config) Option {
	return func(service *Service) {
		service.config = config
	}
}
