package queueobserver

import (
	"time"

	"a.yandex-team.ru/travel/notifier/internal/constants"
)

type Config struct {
	ObserveInterval  time.Duration `config:"QUEUE_OBSERVE_INTERVAL" yaml:"observe_interval"`
	ObserveTimeout   time.Duration `config:"QUEUE_OBSERVE_TIMEOUT" yaml:"observe_timeout"`
	YtLockTimeout    time.Duration `config:"QUEUE_OBSERVE_YT_LOCK_TIMEOUT" yaml:"yt_lock_timeout"`
	YtLockPathPrefix string        `config:"QUEUE_OBSERVE_YT_LOCK_PATH_PREFIX" yaml:"yt_lock_path_prefix"`
	YtLockDirectory  string        `config:"QUEUE_OBSERVE_YT_LOCK_DIRECTORY" yaml:"yt_lock_directory"`
	Disabled         bool          `config:"QUEUE_OBSERVE_DISABLED" yaml:"disabled"`
	Environment      string        `yaml:"environment"`
}

var DefaultConfig = Config{
	ObserveInterval:  15 * time.Second,
	ObserveTimeout:   5 * time.Second,
	YtLockTimeout:    2 * time.Second,
	YtLockPathPrefix: constants.DefaultYtLockPathPrefix,
	YtLockDirectory:  "queue_observing",
	Disabled:         false,
}
