package rollout

import "github.com/OneOfOne/xxhash"

type Config struct {
	Percentage uint64 `config:"ROLL_OUT_PERCENTAGE" yaml:"percentage"`
}

var DefaultConfig = Config{Percentage: 100}

type Service struct {
	config Config
}

func NewService(config Config) *Service {
	return &Service{config: config}
}

func (s *Service) IsEnabledForEmail(email string) bool {
	return s.getBucket(email) < s.config.Percentage
}

func (s *Service) getBucket(email string) uint64 {
	return xxhash.ChecksumString64(email) % 100
}
