package subscriptions

import (
	pb "a.yandex-team.ru/travel/notifier/api/subscriptions/v1"
	"a.yandex-team.ru/travel/notifier/internal/service/subscriptions/models"
)

type BetterPriceSubscriptionMapper struct {
}

func NewBetterPriceSubscriptionMapper() *BetterPriceSubscriptionMapper {
	return &BetterPriceSubscriptionMapper{}
}

func (b *BetterPriceSubscriptionMapper) Map(request *pb.BetterPriceSubscribeReq) *models.BetterPriceSubscription {
	return &models.BetterPriceSubscription{
		Email:           request.Email,
		Source:          request.Source,
		Vertical:        request.TravelVertical,
		UserTimezone:    request.UserTimezone,
		Language:        request.Language,
		NationalVersion: request.NationalVersion,
		Variant: models.Variant{
			ForwardFlights:  b.mapFlights(request.Variant.ForwardFlights),
			BackwardFlights: b.mapFlights(request.Variant.BackwardFlights),
		},
		FromPointKey: request.FromPointKey,
		ToPointKey:   request.ToPointKey,
		DateForward:  request.DateForward,
		DateBackward: request.DateBackward,
		Passengers: models.Passengers{
			Adults:   request.Passengers.Adults,
			Children: request.Passengers.Children,
			Infants:  request.Passengers.Infants,
		},
		ServiceClass:         b.mapServiceClass(request.ServiceClass),
		WithBaggage:          request.WithBaggage,
		TariffWithoutBaggage: b.mapTariff(request.TariffWithoutBaggage),
		TariffWithBaggage:    b.mapTariff(request.TariffWithBaggage),
	}
}

func (b *BetterPriceSubscriptionMapper) mapFlights(flights []*pb.Flight) []models.Flight {
	result := make([]models.Flight, 0, len(flights))
	for _, f := range flights {
		result = append(
			result, models.Flight{
				FromStationID:          f.FromStationID,
				ToStationID:            f.ToStationID,
				LocalDepartureDatetime: f.LocalDepartureDatetime,
				CompanyCode:            f.CompanyCode,
				Number:                 f.Number,
			},
		)
	}
	return result
}

func (b *BetterPriceSubscriptionMapper) mapTariff(tariffProto *pb.Tariff) (tariff models.Tariff) {
	if tariffProto == nil {
		return
	}
	if tariffProto.Price != nil {
		tariff.Price = models.Price{
			Currency: tariffProto.Price.Currency,
			Value:    tariffProto.Price.Value,
		}
	}
	if tariffProto.ExchangedPrice != nil {
		tariff.ExchangedPrice = models.Price{
			Currency: tariffProto.ExchangedPrice.Currency,
			Value:    tariffProto.ExchangedPrice.Value,
		}
	}
	return
}

func (b *BetterPriceSubscriptionMapper) mapServiceClass(serviceClass pb.ServiceClass) models.ServiceClass {
	switch serviceClass {
	case pb.ServiceClass_SERVICE_CLASS_ECONOMY:
		return models.ServiceClassEconomy
	case pb.ServiceClass_SERVICE_CLASS_BUSINESS:
		return models.ServiceClassBusiness
	default:
		return models.ServiceClassEconomy
	}
}
