package subscriptions

import (
	"time"

	"a.yandex-team.ru/travel/notifier/internal/models"
)

type Config struct {
	SenderCampaigns            map[models.NotificationSubtype]string `yaml:"sender_campaigns"`
	SendPromoNotifications     bool                                  `yaml:"send_promo_notifications"`
	PromoCodeValidDuration     time.Duration                         `yaml:"promo_code_valid_duration"`
	PromoCodeNotifyStart       time.Duration                         `yaml:"promo_code_notify_start"` // relative to validTill
	PromoCodeNotifyEnd         time.Duration                         `yaml:"promo_code_notify_end"`   // relative to validTill
	PostponeInterval           time.Duration                         `yaml:"postpone_interval"`
	UnsubscribeHashSecret      string                                `config:"SUBSCRIPTIONS_UNSUBSCRIBE_HASH_SECRET" yaml:"unsubscribe_hash_secret"`
	SenderUnsubscribeListSlug  string                                `config:"SUBSCRIPTIONS_SENDER_UNSUBSCRIBE_LIST_SLUG" yaml:"sender_unsubscribe_list_slug"`
	SaltLength                 int                                   `config:"SUBSCRIPTIONS_UNSUBSCRIBE_SALT_LENGTH" yaml:"unsubscribe_salt_length"`
	UnsubscribePath            string                                `config:"SUBSCRIPTIONS_UNSUBSCRIBE_PATH" yaml:"unsubscribe_path"`
	DBStatementTimeout         time.Duration                         `config:"SUBSCRIPTIONS_DB_STATEMENT_TIMEOUT" yaml:"db_statement_timeout"`
	DBLockTimeout              time.Duration                         `config:"SUBSCRIPTIONS_DB_LOCK_TIMEOUT" yaml:"db_lock_timeout"`
	DBIdleInTransactionTimeout time.Duration                         `config:"SUBSCRIPTIONS_DB_IDLE_IN_TRANSACTION_TIMEOUT" yaml:"db_idle_in_transaction_timeout"`
	WaitForLockBeforeSending   bool                                  `config:"SUBSCRIPTIONS_WAIT_FOR_LOCK_BEFORE_SENDING" yaml:"wait_for_lock_before_sending"`
}

var DefaultConfig = Config{
	SenderCampaigns:            map[models.NotificationSubtype]string{},
	SendPromoNotifications:     false,
	PostponeInterval:           10 * time.Minute,
	PromoCodeValidDuration:     7 * 24 * time.Hour,
	PromoCodeNotifyStart:       1 * 24 * time.Hour,
	PromoCodeNotifyEnd:         12 * time.Hour,
	UnsubscribeHashSecret:      "",
	SenderUnsubscribeListSlug:  "",
	SaltLength:                 16,
	UnsubscribePath:            "/subscription/unsubscribe/promo/",
	DBStatementTimeout:         60 * time.Second,
	DBLockTimeout:              10 * time.Second,
	DBIdleInTransactionTimeout: 60 * time.Second,
	WaitForLockBeforeSending:   true,
}
