package subscriptions

import (
	"time"

	"a.yandex-team.ru/library/go/core/metrics"
)

const (
	subscriptionsMetricsPrefix = "subscriptions"
	senderMetricsPrefix        = subscriptionsMetricsPrefix + ".sender"

	processingPhaseMetricName = "processing"
	sendingPhaseMetricName    = "sending"

	successfulSendingMetricName     = "sent"
	failedSendingMetricName         = "failed"
	postponedNotificationMetricName = "postponed"

	expiredNotificationMetricName = "expired"
	senderTimingsMetricName       = "timings"
	senderRequestsMetricName      = "requests"

	postponementReasonFailedTxCommit = "failed_tx_commit"
)

var senderLatencyBuckets = metrics.MakeExponentialDurationBuckets(time.Millisecond, 1.3, 40)
