package models

type BetterPriceSubscription struct {
	Email           string
	Source          string
	Vertical        string
	UserTimezone    string
	Language        string
	NationalVersion string

	Variant              Variant
	FromPointKey         string
	ToPointKey           string
	DateForward          string
	DateBackward         string
	Passengers           Passengers
	ServiceClass         ServiceClass
	WithBaggage          bool
	TariffWithoutBaggage Tariff
	TariffWithBaggage    Tariff
}

type Variant struct {
	ForwardFlights  []Flight
	BackwardFlights []Flight
}

type Flight struct {
	FromStationID          uint32
	ToStationID            uint32
	LocalDepartureDatetime string
	CompanyCode            string
	Number                 string
}

type Passengers struct {
	Adults   uint32
	Children uint32
	Infants  uint32
}

type ServiceClass string

func (s ServiceClass) String() string {
	return string(s)
}

const (
	ServiceClassEconomy  ServiceClass = "economy"
	ServiceClassBusiness ServiceClass = "business"
)

type Tariff struct {
	Price          Price
	ExchangedPrice Price
}

type Price struct {
	Currency string
	Value    float64
}
