package subscriptions

import (
	"crypto/hmac"
	"crypto/md5"
	"crypto/rand"
	"encoding/hex"
)

type SaltProvider interface {
	GetSalt(length int) string
}

type MD5UnsubscribeHashGenerator struct {
	unsubscribtionSecretKey []byte
	saltProvider            SaltProvider
	saltLength              int
}

func NewMD5UnsubscribeHashGenerator(
	unsubscribtionSecretKey string,
	saltProvider SaltProvider,
	saltLength int,
) *MD5UnsubscribeHashGenerator {
	return &MD5UnsubscribeHashGenerator{
		unsubscribtionSecretKey: []byte(unsubscribtionSecretKey),
		saltProvider:            saltProvider,
		saltLength:              saltLength,
	}
}

func (g *MD5UnsubscribeHashGenerator) Generate(toBeHashed string) string {
	hasher := hmac.New(md5.New, g.unsubscribtionSecretKey)
	hasher.Write([]byte(toBeHashed))
	hasher.Write([]byte(g.saltProvider.GetSalt(g.saltLength)))
	return hex.EncodeToString(hasher.Sum(nil))
}

type RandSaltProvider struct{}

func (p *RandSaltProvider) GetSalt(length int) string {
	salt := make([]byte, length)
	_, _ = rand.Read(salt)
	return string(salt)
}
